/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\rMa\u0001B A\u0001\u0015C\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tG\u0002\u0011)\u0019!C\u0001I\"A1\u000f\u0001B\u0001B\u0003%Q\r\u0003\u0005u\u0001\t\u0015\r\u0011\"\u0001v\u0011%\ty\u0001\u0001B\u0001B\u0003%a\u000f\u0003\u0006\u0002\u0012\u0001\u0011)\u0019!C\u0001\u0003'A!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011q\u0004\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011%\tI\u0004\u0001a\u0001\n\u0013\tY\u0004C\u0005\u0002>\u0001\u0001\r\u0011\"\u0003\u0002@!9\u00111\n\u0001!B\u0013y\u0006BCA+\u0001\t\u0007I\u0011\u0001!\u0002X!A\u0011q\f\u0001!\u0002\u0013\tI\u0006C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002d!A\u00111\u000e\u0001!\u0002\u0013\t)\u0007\u0003\u0006\u0002n\u0001\u0011\r\u0011\"\u0001A\u0003_B\u0001Ba\u0011\u0001A\u0003%\u0011\u0011\u000f\u0005\t\u0005\u000b\u0002A\u0011\u0001!\u0003H!9!\u0011\n\u0001\u0005\u0002\u0005\u0015\bb\u0002B&\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0005\u001b\u0002A\u0011\tB(\u0011\u001d\u00119\u0006\u0001C!\u00053BqA!\u001a\u0001\t\u0003\u00129\u0007C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\tU\u0004\u0001\"\u0001\u0003x!9!Q\u0010\u0001\u0005\u0002\t}\u0004b\u0002BF\u0001\u0011\u0005!Q\u0012\u0005\b\u0005'\u0003A\u0011\u0001BK\u0011\u001d\u0011y\n\u0001C\u0001\u0005CCqA!*\u0001\t\u0003\u00119\u000bC\u0004\u00034\u0002!\tA!.\t\u0013\t}\u0006!%A\u0005\u0002\t\u0005\u0007b\u0002Bl\u0001\u0011\u0005!\u0011\u001c\u0005\t\u0005G\u0004A\u0011\u0001\"\u0002<!A!Q\u001d\u0001\u0005\u0002\u0001\u00139EB\u0004\u0002\u0002\u0002\u0001\u0001)a!\t\u0015\u0005-UE!A!\u0002\u0013\ti\tC\u0004\u0002*\u0015\"\t!a%\t\u000f\u0005]U\u0005\"\u0015\u0002\u001a\"I\u0011qU\u0013C\u0002\u0013\u0005\u0011\u0011\u0016\u0005\t\u0003c+\u0003\u0015!\u0003\u0002,\"I\u00111W\u0013A\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003{+\u0003\u0019!C\u0001\u0003\u007fC\u0001\"a1&A\u0003&\u0011q\u0017\u0005\n\u0003\u000f,\u0003\u0019!C\u0001\u0003\u0013D\u0011\"!5&\u0001\u0004%\t!a5\t\u0011\u0005]W\u0005)Q\u0005\u0003\u0017Dq!a7&\t\u0013\ti\u000eC\u0004\u0002d\u0016\"\t%!:\t\u000f\u0005\u001dX\u0005\"\u0003\u0002j\"9\u0011\u0011_\u0013\u0005\n\u0005%\bb\u0002B\u0002K\u0011%!Q\u0001\u0005\b\u0005#)C\u0011\u0001B\n\u000f\u001d\u00119\u000f\u0011E\u0001\u0005S4aa\u0010!\t\u0002\t-\bbBA\u0015q\u0011\u0005!Q\u001e\u0005\n\u0005_D$\u0019!C\u0001\u0005cD\u0001B!>9A\u0003%!1\u001f\u0005\b\u0005oDD\u0011\u0001B}\u0011\u001d\u0011i\u0010\u000fC\u0001\u0005\u007fD\u0011b!\u00049#\u0003%\taa\u0004\u0003\u00151{wm\u00117fC:,'O\u0003\u0002B\u0005\u0006\u0019An\\4\u000b\u0003\r\u000bQa[1gW\u0006\u001c\u0001aE\u0003\u0001\r2\u0013\u0006\f\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\n\u000bQ!\u001e;jYNL!!\u0015(\u0003\u000f1{wmZ5oOB\u00111KV\u0007\u0002)*\u0011QKQ\u0001\b[\u0016$(/[2t\u0013\t9FKA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\u0004\"!\u0017/\u000e\u0003iS!a\u0017\"\u0002\rM,'O^3s\u0013\ti&L\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005\u0001\fW\"\u0001!\n\u0005\t\u0004%!D\"mK\u0006tWM]\"p]\u001aLw-A\u0004m_\u001e$\u0015N]:\u0016\u0003\u0015\u00042AZ5l\u001b\u00059'B\u00015I\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003U\u001e\u00141aU3r!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0002j_*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:n\u0005\u00111\u0015\u000e\\3\u0002\u00111|w\rR5sg\u0002\nA\u0001\\8hgV\ta\u000fE\u0003Nof\fI!\u0003\u0002y\u001d\n!\u0001k\\8m!\rQ\u0018QA\u0007\u0002w*\u0011A0`\u0001\u0007G>lWn\u001c8\u000b\u0005\rs(bA@\u0002\u0002\u00051\u0011\r]1dQ\u0016T!!a\u0001\u0002\u0007=\u0014x-C\u0002\u0002\bm\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002a\u0003\u0017I1!!\u0004A\u0005\raunZ\u0001\u0006Y><7\u000fI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0005\u0005U\u0001cA-\u0002\u0018%\u0019\u0011\u0011\u0004.\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\nA\u0001^5nKB!\u0011\u0011EA\u0013\u001b\t\t\u0019C\u0003\u0002Pw&!\u0011qEA\u0012\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)1\ti#a\f\u00022\u0005M\u0012QGA\u001c!\t\u0001\u0007\u0001C\u0003_\u0013\u0001\u0007q\fC\u0003d\u0013\u0001\u0007Q\rC\u0003u\u0013\u0001\u0007a\u000fC\u0004\u0002\u0012%\u0001\r!!\u0006\t\u0013\u0005u\u0011\u0002%AA\u0002\u0005}\u0011AB2p]\u001aLw-F\u0001`\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003\u0003\n9\u0005E\u0002H\u0003\u0007J1!!\u0012I\u0005\u0011)f.\u001b;\t\u0011\u0005%3\"!AA\u0002}\u000b1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002B3\u0001DA(!\r9\u0015\u0011K\u0005\u0004\u0003'B%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001d\rdW-\u00198fe6\u000bg.Y4feV\u0011\u0011\u0011\f\t\u0004A\u0006m\u0013bAA/\u0001\n\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002\n\u0011\u0002\u001e5s_R$H.\u001a:\u0016\u0005\u0005\u0015\u0004cA'\u0002h%\u0019\u0011\u0011\u000e(\u0003\u0013QC'o\u001c;uY\u0016\u0014\u0018A\u0003;ie>$H\u000f\\3sA\u0005A1\r\\3b]\u0016\u00148/\u0006\u0002\u0002rA1\u00111OA=\u0003{j!!!\u001e\u000b\u0007\u0005]t-A\u0004nkR\f'\r\\3\n\t\u0005m\u0014Q\u000f\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002\u0002\u0000\u0015j\u0011\u0001\u0001\u0002\u000e\u00072,\u0017M\\3s)\"\u0014X-\u00193\u0014\u0007\u0015\n)\tE\u0002N\u0003\u000fK1!!#O\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0002\u0011QD'/Z1e\u0013\u0012\u00042aRAH\u0013\r\t\t\n\u0013\u0002\u0004\u0013:$H\u0003BA?\u0003+Cq!a#(\u0001\u0004\ti)\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!a'\u0011\t\u0005u\u00151U\u0007\u0003\u0003?S1!!)p\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0016q\u0014\u0002\u0007'R\u0014\u0018N\\4\u0002\u000f\rdW-\u00198feV\u0011\u00111\u0016\t\u0004A\u00065\u0016bAAX\u0001\n91\t\\3b]\u0016\u0014\u0018\u0001C2mK\u0006tWM\u001d\u0011\u0002\u00131\f7\u000f^*uCR\u001cXCAA\\!\r\u0001\u0017\u0011X\u0005\u0004\u0003w\u0003%\u0001D\"mK\u0006tWM]*uCR\u001c\u0018!\u00047bgR\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0003\u0002B\u0005\u0005\u0007\"CA%Y\u0005\u0005\t\u0019AA\\\u0003)a\u0017m\u001d;Ti\u0006$8\u000f\t\u0015\u0004[\u0005=\u0013!\u00057bgR\u0004&/Z\"mK\u0006t7\u000b^1ugV\u0011\u00111\u001a\t\u0004A\u00065\u0017bAAh\u0001\ni\u0001K]3DY\u0016\fgn\u0015;biN\fQ\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0003\u0002B\u0005U\u0007\"CA%_\u0005\u0005\t\u0019AAf\u0003Ia\u0017m\u001d;Qe\u0016\u001cE.Z1o'R\fGo\u001d\u0011)\u0007A\ny%A\u0005dQ\u0016\u001c7\u000eR8oKR!\u0011\u0011IAp\u0011\u0019\t\t/\ra\u0001s\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u00023p/>\u00148\u000e\u0006\u0002\u0002B\u0005!BO]=DY\u0016\fgNR5mi\"LWm\u001d;M_\u001e$\"!a;\u0011\u0007\u001d\u000bi/C\u0002\u0002p\"\u0013qAQ8pY\u0016\fg.A\tdY\u0016\fgNR5mi\"LWm\u001d;M_\u001eDS\u0001NA{\u0005\u0003\u0001RaRA|\u0003wL1!!?I\u0005\u0019!\bN]8xgB\u0019\u0001-!@\n\u0007\u0005}\bI\u0001\u000bM_\u001e\u001cE.Z1oS:<W\t_2faRLwN\\\u0012\u0003\u0003w\f\u0001b\u00197fC:dun\u001a\u000b\u0005\u0003\u0003\u00129\u0001C\u0004\u0003\nU\u0002\rAa\u0003\u0002\u0013\rdW-\u00198bE2,\u0007c\u00011\u0003\u000e%\u0019!q\u0002!\u0003\u00151{w\rV8DY\u0016\fg.A\u0006sK\u000e|'\u000fZ*uCR\u001cH\u0003DA!\u0005+\u0011IB!\r\u0003<\t}\u0002b\u0002B\fm\u0001\u0007\u0011QR\u0001\u0003S\u0012DqAa\u00077\u0001\u0004\u0011i\"\u0001\u0003oC6,\u0007\u0003\u0002B\u0010\u0005[qAA!\t\u0003*A\u0019!1\u0005%\u000e\u0005\t\u0015\"b\u0001B\u0014\t\u00061AH]8pizJ1Aa\u000bI\u0003\u0019\u0001&/\u001a3fM&!\u0011Q\u0015B\u0018\u0015\r\u0011Y\u0003\u0013\u0005\b\u0005g1\u0004\u0019\u0001B\u001b\u0003\u00111'o\\7\u0011\u0007\u001d\u00139$C\u0002\u0003:!\u0013A\u0001T8oO\"9!Q\b\u001cA\u0002\tU\u0012A\u0001;p\u0011\u001d\u0011\tE\u000ea\u0001\u0003o\u000bQa\u001d;biN\f\u0011b\u00197fC:,'o\u001d\u0011\u0002\u001f\u0011,\u0017\r\u001a+ie\u0016\fGmQ8v]R,\"!!$\u0002\u000fM$\u0018M\u001d;va\u0006A1\u000f[;uI><h.A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\tE\u0003#\u00024\u0003T\tu\u0011b\u0001B+O\n\u00191+\u001a;\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tG\u0003BA!\u00057BqA!\u0018\u0018\u0001\u0004\u0011y&A\u0005oK^\u001cuN\u001c4jOB\u0019\u0011L!\u0019\n\u0007\t\r$LA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>tg-[4ve\u0016$b!!\u0011\u0003j\t5\u0004b\u0002B61\u0001\u0007!qL\u0001\n_2$7i\u001c8gS\u001eDqA!\u0018\u0019\u0001\u0004\u0011y&A\u0007bE>\u0014Ho\u00117fC:Lgn\u001a\u000b\u0005\u0003\u0003\u0012\u0019\b\u0003\u0004\u0002bf\u0001\r!_\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0003BA!\u0005sBaAa\u001f\u001b\u0001\u0004Y\u0017a\u00023bi\u0006$\u0015N]\u0001\u0013C2$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'\u000f\u0006\u0005\u0002B\t\u0005%1\u0011BD\u0011\u0019\t\to\u0007a\u0001s\"1!QQ\u000eA\u0002-\fAb]8ve\u000e,Gj\\4ESJDaA!#\u001c\u0001\u0004Y\u0017A\u00033fgRdun\u001a#je\u0006\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR!\u0011\u0011\tBH\u0011\u001d\u0011\t\n\ba\u0001\u0005;\t1\u0001Z5s\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002B\t]%\u0011\u0014BN\u0011\u0019\u0011Y(\ba\u0001W\"1\u0011\u0011]\u000fA\u0002eDqA!(\u001e\u0001\u0004\u0011)$\u0001\u0004pM\u001a\u001cX\r^\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\t\tEa)\t\r\u0005\u0005h\u00041\u0001z\u00039\u0011Xm];nK\u000ecW-\u00198j]\u001e$B!!\u0011\u0003*\"9!1V\u0010A\u0002\t5\u0016a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\t\u0019\u0014y+_\u0005\u0004\u0005c;'\u0001C%uKJ\f'\r\\3\u0002\u0019\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3\u0015\u0011\u0005-(q\u0017B]\u0005wCa!!9!\u0001\u0004I\bb\u0002BOA\u0001\u0007!Q\u0007\u0005\n\u0005{\u0003\u0003\u0013!a\u0001\u0005k\t\u0011\"\\1y/\u0006LG/T:\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIM*\"Aa1+\t\tU\"QY\u0016\u0003\u0005\u000f\u0004BA!3\u0003T6\u0011!1\u001a\u0006\u0005\u0005\u001b\u0014y-A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u001b%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003V\n-'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061\u0003/Y;tK\u000ecW-\u00198j]\u001e4uN\u001d(p]\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0005\tm\u0007#\u00024\u00030\nu\u0007CB$\u0003`f\fI!C\u0002\u0003b\"\u0013a\u0001V;qY\u0016\u0014\u0014!D2veJ,g\u000e^\"p]\u001aLw-\u0001\u0007dY\u0016\fg.\u001a:D_VtG/\u0001\u0006M_\u001e\u001cE.Z1oKJ\u0004\"\u0001\u0019\u001d\u0014\u0005a2EC\u0001Bu\u0003U\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"Aa=\u0011\u000b\u0019\u0014\u0019&a'\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\nQb\u00197fC:,'oQ8oM&<GcA0\u0003|\"9\u0011\u0011\b\u001fA\u0002\t}\u0013aF2sK\u0006$XMT3x\u00072,\u0017M\\3e'\u0016<W.\u001a8u)\u0019\u0019\taa\u0002\u0004\nA\u0019\u0001ma\u0001\n\u0007\r\u0015\u0001I\u0001\u0006M_\u001e\u001cVmZ7f]RDa!Q\u001fA\u0002\u0005%\u0001bBB\u0006{\u0001\u0007!QG\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0004\u0012)\"\u0011q\u0004Bc\u0001")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static LogSegment createNewCleanedSegment(Log log, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(log, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.kafka$log$LogCleaner$$config().numThreads());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogCleaner.$anonfun$startup$2(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig(newConfig).numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return (double)100 * x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1))).max((Ordering)Ordering.Double$.MODULE$));
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().iterator().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5))).max((Ordering)Ordering.Double$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        return Math.max(0, (int)(BoxesRunTime.unboxToLong((Object)this.cleaners().iterator().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)LogCleaner.$anonfun$new$10(x$6))).max((Ordering)Ordering.Long$.MODULE$)) / 1000L));
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$startup$2(LogCleaner $this, int i) {
        CleanerThread cleaner = $this.new CleanerThread(i);
        $this.cleaners().$plus$eq((Object)cleaner);
        cleaner.start();
    }

    public static final /* synthetic */ boolean $anonfun$awaitCleaned$1() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$awaitCleaned$2(long offset$1, long x$9) {
        return x$9 >= offset$1;
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        boolean bl;
        Option option = this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1);
        if (option == null) {
            throw null;
        }
        Option fold_this = option;
        if (fold_this.isEmpty()) {
            bl = LogCleaner.$anonfun$awaitCleaned$1();
        } else {
            long l = BoxesRunTime.unboxToLong((Object)fold_this.get());
            bl = LogCleaner.$anonfun$awaitCleaned$2(offset$1, l);
        }
        return bl;
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$11();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().dir().getParent(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(option)) {
                bl = false;
            } else if (option instanceof Some) {
                boolean bl2;
                LogToClean cleanable = (LogToClean)((Some)option).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    boolean bl3 = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl3) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
                bl = bl2;
            } else {
                throw new MatchError(option);
            }
            Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$10 -> (TopicPartition)x$10._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long endOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var5_4;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, (CleanerStats)var7_5);
                    endOffset = var5_4;
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().dir().getParent();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String string = "%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string2 = "\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string3 = "\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string4 = "\tBuffer utilization: %.1f%%%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string5 = "\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string6 = "\tStart size: %,.1f MB (%,d messages)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string7 = "\tEnd size: %,.1f MB (%,d messages)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string8 = "\t%.1f%% size reduction (%.1f%% fewer messages)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String message = new StringBuilder(0).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(string2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(string3).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(string4).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(string5).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(string6).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(string7).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(string8).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                    String string = "\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d";
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())}));
                });
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                    String string = "\tFound %d invalid messages during compaction.";
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())}));
                });
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            int n;
            if (x0$1 != null) {
                Log log = (Log)x0$1._2();
                try {
                    n = log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    boolean bl = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(null);
            }
            int n2 = n;
            return n2;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

