/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_hy extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CNH = "CNH";
        final Object[][] data = new Object[][] {
            { "mwk", "\u0574\u0561\u056c\u0561\u057e\u056b\u0561\u056f\u0561\u0576 \u056f\u057e\u0561\u0579\u0561" },
            { "FJD", "FJD" },
            { "STD", "STD" },
            { "LVL", "LVL" },
            { "SCR", "SCR" },
            { "CDF", "CDF" },
            { "BBD", "BBD" },
            { "mga", "\u0544\u0561\u0564\u0561\u0563\u0561\u057d\u056f\u0561\u0580\u056b \u0561\u0580\u056b\u0561\u0580\u056b" },
            { "HNL", "HNL" },
            { "UGX", "UGX" },
            { "ZAR", "ZAR" },
            { "STN", "STN" },
            { "bam", "\u0532\u0578\u057d\u0576\u056b\u0561 \u0587 \u0540\u0565\u0580\u0581\u0565\u0563\u0578\u057e\u056b\u0576\u0561\u0575\u056b \u0583\u0578\u056d\u0561\u0580\u056f\u057e\u0578\u0572 \u0574\u0561\u0580\u056f" },
            { "egp", "\u0565\u0563\u056b\u057a\u057f\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "CUC", "CUC" },
            { "ssp", "\u0570\u0561\u0580\u0561\u057e\u057d\u0578\u0582\u0564\u0561\u0576\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "BSD", "BSD" },
            { "nio", "\u0576\u056b\u056f\u0561\u0580\u0561\u0563\u0578\u0582\u0561\u056f\u0561\u0576 \u056f\u0578\u0580\u0564\u0578\u0562\u0561" },
            { "SDG", "SDG" },
            { "nzd", "\u0576\u0578\u0580\u0566\u0565\u056c\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "IQD", "IQD" },
            { "brl", "\u0562\u0580\u0561\u0566\u056b\u056c\u0561\u056f\u0561\u0576 \u057c\u0565\u0561\u056c" },
            { "CUP", "CUP" },
            { "GMD", "GMD" },
            { "fjd", "\u0586\u056b\u057b\u056b\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "RSD", "RSD" },
            { "mxn", "\u0574\u0565\u0584\u057d\u056b\u056f\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "std", "\u054d\u0561\u0576 \u054f\u0578\u0574\u0565 \u0587 \u0553\u0580\u056b\u0576\u057d\u056b\u057a\u056b\u056b \u0564\u0578\u0562\u0580\u0561 (1977\u20132017)" },
            { "lvl", "\u053c\u0561\u057f\u057e\u056b\u0561\u056f\u0561\u0576 \u056c\u0561\u057f" },
            { "scr", "\u057d\u0565\u0575\u0577\u0565\u056c\u0575\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "cdf", "\u053f\u0578\u0576\u0563\u0578\u0575\u056b \u0586\u0580\u0561\u0576\u056f" },
            { "bbd", "\u0562\u0561\u0580\u0562\u0561\u0564\u0578\u057d\u0575\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "MYR", "MYR" },
            { "hnl", "\u0570\u0578\u0576\u0564\u0578\u0582\u0580\u0561\u057d\u0561\u056f\u0561\u0576 \u056c\u0565\u0574\u057a\u056b\u0580\u0561" },
            { "ugx", "\u0578\u0582\u0563\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0577\u056b\u056c\u056b\u0576\u0563" },
            { "FKP", "FKP" },
            { "zar", "\u0570\u0561\u0580\u0561\u057e\u0561\u0586\u0580\u056b\u056f\u0575\u0561\u0576 \u057c\u0561\u0576\u0564" },
            { "stn", "\u054d\u0561\u0576 \u054f\u0578\u0574\u0565 \u0587 \u0553\u0580\u056b\u0576\u057d\u056b\u057a\u056b\u056b \u0564\u0578\u0562\u0580\u0561" },
            { "UYU", "UYU" },
            { "cuc", "\u056f\u0578\u0582\u0562\u0561\u0575\u0561\u056f\u0561\u0576 \u0583\u0578\u056d\u0561\u0580\u056f\u057e\u0578\u0572 \u057a\u0565\u057d\u0578" },
            { "bsd", "\u0562\u0561\u0570\u0561\u0574\u0575\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "CVE", "CVE" },
            { "OMR", "OMR" },
            { "sdg", "\u057d\u0578\u0582\u0564\u0561\u0576\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "KES", "KES" },
            { "SEK", "SEK" },
            { "BTN", "BTN" },
            { "iqd", "\u056b\u0580\u0561\u0584\u0575\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "GNF", "GNF" },
            { "cup", "\u056f\u0578\u0582\u0562\u0561\u0575\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "gmd", "\u0563\u0561\u0574\u0562\u056b\u0561\u056f\u0561\u0576 \u0564\u0561\u056c\u0561\u057d\u056b" },
            { "MZN", "MZN" },
            { "twd", "\u0569\u0561\u0575\u057e\u0561\u0576\u0561\u056f\u0561\u0576 \u0576\u0578\u0580 \u0564\u0578\u056c\u0561\u0580" },
            { "ARS", "ARS" },
            { "rsd", "\u057d\u0565\u0580\u0562\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "QAR", "QAR" },
            { "myr", "\u0574\u0561\u056c\u0561\u0575\u0566\u056b\u0561\u056f\u0561\u0576 \u057c\u056b\u0576\u0563\u056b\u057f" },
            { "IRR", "IRR" },
            { "fkp", "\u0556\u0578\u056c\u0584\u056c\u0565\u0576\u0564\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580\u056b \u0586\u0578\u0582\u0576\u057f" },
            { "xof", "\u0531\u0580\u0587\u0574\u057f\u0575\u0561\u0576 \u0531\u0586\u0580\u056b\u056f\u0561\u0575\u056b \u053f\u0556\u0531 \u0586\u0580\u0561\u0576\u056f" },
            { "THB", "\u0e3f" },
            { "UZS", "UZS" },
            { "uyu", "\u0578\u0582\u0580\u0578\u0582\u0563\u057e\u0561\u0575\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "BDT", "BDT" },
            { "cve", "\u053f\u0561\u0562\u0578 \u054e\u0565\u0580\u0564\u0565\u056b \u0567\u057d\u056f\u0578\u0582\u0564\u0578" },
            { "omr", "\u0555\u0574\u0561\u0576\u056b \u057c\u056b\u0561\u056c" },
            { "LYD", "LYD" },
            { "kes", "\u0584\u0565\u0576\u056b\u0561\u056f\u0561\u0576 \u0577\u056b\u056c\u056b\u0576\u0563" },
            { "sek", "\u0577\u057e\u0565\u0564\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576" },
            { "KWD", "KWD" },
            { "btn", "\u0562\u0578\u0582\u0569\u0561\u0576\u0561\u056f\u0561\u0576 \u0576\u0563\u0578\u0582\u056c\u057f\u0580\u0578\u0582\u0574" },
            { "RUB", "RUB" },
            { "gnf", "\u0563\u057e\u056b\u0576\u0565\u0561\u056f\u0561\u0576 \u0586\u0580\u0561\u0576\u056f" },
            { "ISK", "ISK" },
            { "mzn", "\u0574\u0578\u0566\u0561\u0574\u0562\u056b\u056f\u0575\u0561\u0576 \u0574\u0565\u057f\u056b\u056f\u0561\u056c" },
            { "ars", "\u0561\u0580\u0563\u0565\u0576\u057f\u056b\u0576\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "qar", "\u053f\u0561\u057f\u0561\u0580\u056b \u057c\u056b\u0561\u056c" },
            { "MKD", "MKD" },
            { "irr", "\u056b\u0580\u0561\u0576\u0561\u056f\u0561\u0576 \u057c\u056b\u0561\u056c" },
            { "DZD", "DZD" },
            { "thb", "\u0569\u0561\u0575\u056c\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0562\u0561\u057f" },
            { "uzs", "\u0578\u0582\u0566\u0562\u0565\u056f\u0561\u056f\u0561\u0576 \u057d\u0578\u0574" },
            { "xpf", "\u053f\u054a\u0556 \u0586\u0580\u0561\u0576\u056f" },
            { "PAB", "PAB" },
            { "SGD", "SGD" },
            { "bdt", "\u0532\u0561\u0576\u0563\u056c\u0561\u0564\u0565\u0577\u056b \u057f\u0561\u056f\u0561" },
            { "KGS", "KGS" },
            { "lyd", "\u056c\u056b\u0562\u056b\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "kwd", "\u0554\u0578\u0582\u057e\u0565\u0575\u0569\u056b \u0564\u056b\u0576\u0561\u0580" },
            { "rub", "\u057c\u0578\u0582\u057d\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0562\u056c\u056b" },
            { "CHF", "CHF" },
            { "HRK", "HRK" },
            { "isk", "\u056b\u057d\u056c\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576" },
            { "DJF", "DJF" },
            { "mkd", "\u0574\u0561\u056f\u0565\u0564\u0578\u0576\u0561\u056f\u0561\u0576 \u0564\u0565\u0576\u0561\u0580" },
            { "TZS", "TZS" },
            { "dzd", "\u0561\u056c\u056a\u056b\u0580\u0561\u056f\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "pab", "\u057a\u0561\u0576\u0561\u0574\u0561\u056f\u0561\u0576 \u0562\u0561\u056c\u0562\u0578\u0561" },
            { "sgd", "\u054d\u056b\u0576\u0563\u0561\u057a\u0578\u0582\u0580\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "KHR", "KHR" },
            { "IDR", "IDR" },
            { "kgs", "\u0572\u0580\u0572\u0566\u0561\u056f\u0561\u0576 \u057d\u0578\u0574" },
            { "KYD", "KYD" },
            { "BWP", "BWP" },
            { "SHP", "SHP" },
            { "TJS", "TJS" },
            { "xaf", "\u053f\u0565\u0576\u057f\u0580\u0578\u0576\u0561\u056f\u0561\u0576 \u0531\u0586\u0580\u056b\u056f\u0561\u0575\u056b \u053f\u0556\u0531 \u0586\u0580\u0561\u0576\u056f" },
            { "AED", "AED" },
            { "RWF", "RWF" },
            { "chf", "\u0577\u057e\u0565\u0575\u0581\u0561\u0580\u0561\u056f\u0561\u0576 \u0586\u0580\u0561\u0576\u056f" },
            { "hrk", "\u056d\u0578\u0580\u057e\u0561\u0569\u0561\u056f\u0561\u0576 \u056f\u0578\u0582\u0576\u0561" },
            { "djf", "\u054b\u056b\u0562\u0578\u0582\u0569\u056b\u056b \u0586\u0580\u0561\u0576\u056f" },
            { "DKK", "DKK" },
            { "BGN", "BGN" },
            { "MMK", "MMK" },
            { "NOK", "NOK" },
            { "SYP", "SYP" },
            { "tzs", "\u057f\u0561\u0576\u0566\u0561\u0576\u056b\u0561\u056f\u0561\u0576 \u0577\u056b\u056c\u056b\u0576\u0563" },
            { "vnd", "\u057e\u056b\u0565\u057f\u0576\u0561\u0574\u0561\u056f\u0561\u0576 \u0564\u0578\u0576\u0563" },
            { "aud", "\u0561\u057e\u057d\u057f\u0580\u0561\u056c\u056b\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "LKR", "LKR" },
            { "khr", "\u056f\u0561\u0574\u0562\u0578\u057b\u0561\u056f\u0561\u0576 \u057c\u056b\u0565\u056c" },
            { "CZK", "CZK" },
            { "idr", "\u056b\u0576\u0564\u0578\u0576\u0565\u0566\u056b\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "kyd", "\u053f\u0561\u0575\u0574\u0561\u0576\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "HTG", "HTG" },
            { "bwp", "\u0562\u0578\u0569\u057d\u057e\u0561\u0576\u0561\u056f\u0561\u0576 \u057a\u0578\u0582\u056c\u0561" },
            { "shp", "\u054d\u0578\u0582\u0580\u0562 \u0540\u0565\u0572\u056b\u0576\u0565\u056b \u0586\u0578\u0582\u0576\u057f" },
            { "tjs", "\u057f\u0561\u057b\u056b\u056f\u0561\u056f\u0561\u0576 \u057d\u0578\u0574\u0578\u0576\u056b" },
            { "BHD", "BHD" },
            { "rwf", "\u057c\u0578\u0582\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0586\u0580\u0561\u0576\u056f" },
            { "aed", "\u0531\u0580\u0561\u0562\u0561\u056f\u0561\u0576 \u0544\u056b\u0561\u0581\u0575\u0561\u056c \u0537\u0574\u056b\u0580\u0578\u0582\u0569\u0575\u0578\u0582\u0576\u0576\u0565\u0580\u056b \u0564\u056b\u0580\u0570\u0561\u0574" },
            { "KZT", "KZT" },
            { "SZL", "SZL" },
            { "dkk", "\u0564\u0561\u0576\u056b\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576" },
            { "YER", "YER" },
            { "bgn", "\u0562\u0578\u0582\u056c\u0572\u0561\u0580\u0561\u056f\u0561\u0576 \u056c\u0587" },
            { "AFN", "AFN" },
            { "mmk", "\u0544\u0575\u0561\u0576\u0574\u0561\u0575\u056b \u056f\u0575\u0561\u057f" },
            { "nok", "\u0576\u0578\u0580\u057e\u0565\u0563\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576" },
            { "syp", "\u057d\u056b\u0580\u056b\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "AWG", "AWG" },
            { "NPR", "NPR" },
            { "MNT", "MNT" },
            { "lkr", "\u0547\u0580\u056b \u053c\u0561\u0576\u056f\u0561\u0575\u056b \u057c\u0578\u0582\u0583\u056b" },
            { "czk", "\u0579\u0565\u056d\u0561\u056f\u0561\u0576 \u056f\u0580\u0578\u0576" },
            { "BYN", "BYN" },
            { "HUF", "HUF" },
            { "xcd", "\u0561\u0580\u0587\u0565\u056c\u0561\u056f\u0561\u0580\u056b\u0562\u0575\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "BYR", "BYR" },
            { "htg", "\u0570\u0561\u056b\u0569\u0575\u0561\u0576 \u0563\u0578\u0582\u0580\u0564" },
            { "BIF", "BIF" },
            { "bhd", "\u0532\u0561\u0570\u0580\u0565\u0575\u0576\u056b \u0564\u056b\u0576\u0561\u0580" },
            { "kzt", "\u0572\u0561\u0566\u0561\u056d\u0561\u056f\u0561\u0576 \u057f\u0565\u0576\u0563\u0565" },
            { "szl", "\u057d\u057e\u0561\u0566\u056b\u056c\u0565\u0576\u0564\u0561\u056f\u0561\u0576 \u056c\u056b\u056c\u0561\u0576\u0563\u0565\u0576\u056b" },
            { "yer", "\u0565\u0574\u0565\u0576\u0561\u056f\u0561\u0576 \u057c\u056b\u0561\u056c" },
            { "afn", "\u0561\u0586\u0572\u0561\u0576\u0561\u056f\u0561\u0576 \u0561\u0586\u0572\u0561\u0576\u056b" },
            { "BZD", "BZD" },
            { "MOP", "MOP" },
            { "NAD", "NAD" },
            { "awg", "\u0561\u0580\u0578\u0582\u0562\u0561\u056f\u0561\u0576 \u0586\u056c\u0578\u0580\u056b\u0576" },
            { "npr", "\u0546\u0565\u057a\u0561\u056c\u056b \u057c\u0578\u0582\u0583\u056b" },
            { "mnt", "\u0574\u0578\u0576\u0572\u0578\u056c\u0561\u056f\u0561\u0576 \u057f\u0578\u0582\u0563\u0580\u056b\u056f" },
            { "gbp", "\u0562\u0580\u056b\u057f\u0561\u0576\u0561\u056f\u0561\u0576 \u0586\u0578\u0582\u0576\u057f \u057d\u057f\u0565\u0580\u056c\u056b\u0576\u0563" },
            { "byn", "\u0562\u0565\u056c\u0561\u057c\u0578\u0582\u057d\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0562\u056c\u056b" },
            { "PEN", "PEN" },
            { "huf", "\u0570\u0578\u0582\u0576\u0563\u0561\u0580\u0561\u056f\u0561\u0576 \u0586\u0578\u0580\u056b\u0576\u057f" },
            { "WST", "WST" },
            { "TMT", "TMT" },
            { "byr", "\u0532\u0565\u056c\u0561\u057c\u0578\u0582\u057d\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0562\u056c\u056b (2000\u20132016)" },
            { "bif", "\u0562\u0578\u0582\u0580\u0578\u0582\u0576\u0564\u056b\u0561\u056f\u0561\u0576 \u0586\u0580\u0561\u0576\u056f" },
            { "GTQ", "GTQ" },
            { "CLP", "CLP" },
            { "TND", "TND" },
            { "bzd", "\u0532\u0565\u056c\u056b\u0566\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "mop", "\u0544\u0561\u056f\u0561\u0578\u0575\u056b \u057a\u0561\u057f\u0561\u056f\u0561" },
            { "nad", "\u0576\u0561\u0574\u056b\u0562\u056b\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "SLL", "SLL" },
            { "pen", "\u054a\u0565\u0580\u0578\u0582\u056b \u057d\u0578\u056c" },
            { "wst", "\u057d\u0561\u0574\u0578\u0561\u056f\u0561\u0576 \u057f\u0561\u056c\u0561" },
            { "tmt", "\u0569\u0578\u0582\u0580\u0584\u0574\u0565\u0576\u0561\u056f\u0561\u0576 \u0574\u0561\u0576\u0561\u0569" },
            { "DOP", "DOP" },
            { "KMF", "KMF" },
            { "gtq", "\u0563\u057e\u0561\u057f\u0565\u0574\u0561\u056c\u0561\u056f\u0561\u0576 \u056f\u0565\u057f\u057d\u0561\u056c" },
            { "clp", "\u0579\u056b\u056c\u056b\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "tnd", "\u0569\u0578\u0582\u0576\u056b\u057d\u0575\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "GEL", "GEL" },
            { "MAD", "MAD" },
            { "sll", "\u054d\u056b\u0565\u057c\u0561 \u053c\u0565\u0578\u0576\u0565\u056b \u056c\u0565\u0578\u0576\u0565" },
            { "TOP", "TOP" },
            { "AZN", "AZN" },
            { "PGK", "PGK" },
            { "CNH", metaValue_CNH },
            { "UAH", "UAH" },
            { "ERN", "ERN" },
            { "dop", "\u0564\u0578\u0574\u056b\u0576\u056b\u056f\u0575\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "kmf", "\u056f\u0578\u0574\u0578\u0580\u0575\u0561\u0576 \u0586\u0580\u0561\u0576\u056f" },
            { "MRO", "MRO" },
            { "gel", "\u057e\u0580\u0561\u0581\u0561\u056f\u0561\u0576 \u056c\u0561\u0580\u056b" },
            { "mad", "\u0544\u0561\u0580\u0578\u056f\u056f\u0578\u0575\u056b \u0564\u056b\u0580\u0570\u0561\u0574" },
            { "azn", "\u0561\u0564\u0580\u0562\u0565\u057b\u0561\u0576\u0561\u056f\u0561\u0576 \u0574\u0561\u0576\u0561\u0569" },
            { "top", "\u054f\u0578\u0576\u0563\u0561\u0575\u056b \u057a\u0561\u0561\u0576\u0563\u0561" },
            { "pgk", "\u054a\u0561\u057a\u0578\u0582\u0561 \u0546\u0578\u0580 \u0533\u057e\u056b\u0576\u0565\u0561\u0575\u056b \u056f\u056b\u0576\u0561" },
            { "BMD", "BMD" },
            { "PHP", "PHP" },
            { "cnh", metaValue_CNH },
            { "uah", "\u0578\u0582\u056f\u0580\u0561\u056b\u0576\u0561\u056f\u0561\u0576 \u0563\u0580\u056b\u057e\u0576\u0561" },
            { "PYG", "PYG" },
            { "JMD", "JMD" },
            { "ern", "\u0567\u0580\u056b\u0569\u0580\u0565\u0561\u056f\u0561\u0576 \u0576\u0561\u056f\u057e\u0561" },
            { "COP", "COP" },
            { "USD", "$" },
            { "mro", "\u0574\u0561\u057e\u0580\u056b\u057f\u0561\u0576\u0561\u056f\u0561\u0576 \u0578\u0582\u0563\u056b\u0575\u0561 (1973\u20132017)" },
            { "cny", "\u0579\u056b\u0576\u0561\u056f\u0561\u0576 \u0575\u0578\u0582\u0561\u0576" },
            { "mru", "\u0574\u0561\u057e\u0580\u056b\u057f\u0561\u0576\u0561\u056f\u0561\u0576 \u0578\u0582\u0563\u056b\u0575\u0561" },
            { "ETB", "ETB" },
            { "SOS", "SOS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "LAK", "LAK" },
            { "bmd", "\u0562\u0565\u0580\u0574\u0578\u0582\u0564\u0575\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "BND", "BND" },
            { "php", "\u0586\u056b\u056c\u056b\u057a\u056b\u0576\u0575\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "xxx", "\u0561\u0576\u0570\u0561\u0575\u057f \u0561\u0580\u056a\u0578\u0582\u0575\u0569" },
            { "LRD", "LRD" },
            { "pyg", "\u057a\u0561\u0580\u0561\u0563\u057e\u0561\u0575\u0561\u056f\u0561\u0576 \u0563\u0578\u0582\u0561\u0580\u0561\u0576\u056b" },
            { "jmd", "\u0543\u0561\u0574\u0561\u0575\u056f\u0561\u0575\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "ALL", "ALL" },
            { "ZMW", "ZMW" },
            { "cop", "\u056f\u0578\u056c\u0578\u0582\u0574\u0562\u056b\u0561\u056f\u0561\u0576 \u057a\u0565\u057d\u0578" },
            { "usd", "\u0531\u0544\u0546 \u0564\u0578\u056c\u0561\u0580" },
            { "etb", "\u0565\u0569\u0578\u057e\u057a\u056b\u0561\u056f\u0561\u0576 \u0562\u056b\u0580" },
            { "GHS", "GHS" },
            { "GYD", "GYD" },
            { "KPW", "KPW" },
            { "BOB", "BOB" },
            { "MDL", "MDL" },
            { "sos", "\u057d\u0578\u0574\u0561\u056c\u056b\u0561\u056f\u0561\u0576 \u0577\u056b\u056c\u056b\u0576\u0563" },
            { "vef", "\u057e\u0565\u0576\u0565\u057d\u0578\u0582\u0565\u056c\u0561\u056f\u0561\u0576 \u0562\u0578\u056c\u056b\u057e\u0561\u0580" },
            { "vuv", "\u054e\u0561\u0576\u0578\u0582\u0561\u057f\u0578\u0582\u056b \u057e\u0561\u057f\u0578\u0582" },
            { "lak", "\u056c\u0561\u0578\u057d\u0561\u056f\u0561\u0576 \u056f\u056b\u057a" },
            { "AMD", "\u058f" },
            { "bnd", "\u0532\u0580\u0578\u0582\u0576\u0565\u0575\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "zmk", "\u0536\u0561\u0574\u0562\u056b\u0561\u056f\u0561\u0576 \u056f\u057e\u0561\u0579\u0561 (1968\u20132012)" },
            { "TRY", "TRY" },
            { "LBP", "LBP" },
            { "JOD", "JOD" },
            { "lrd", "\u056c\u056b\u0562\u0565\u0580\u056b\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "all", "\u0561\u056c\u0562\u0561\u0576\u0561\u056f\u0561\u0576 \u056c\u0565\u056f" },
            { "zmw", "\u0566\u0561\u0574\u0562\u056b\u0561\u056f\u0561\u0576 \u056f\u057e\u0561\u0579\u0561" },
            { "MUR", "MUR" },
            { "GIP", "GIP" },
            { "RON", "RON" },
            { "ils", "\u053b\u057d\u0580\u0561\u0575\u0565\u056c\u056b \u0576\u0578\u0580 \u0577\u0565\u056f\u0565\u056c" },
            { "ghs", "\u0563\u0561\u0575\u0561\u0576\u0561\u056f\u0561\u0576 \u057d\u0565\u0564\u056b" },
            { "gyd", "\u0563\u0561\u0575\u0561\u0576\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "kpw", "\u0570\u0575\u0578\u0582\u057d\u056b\u057d\u056f\u0578\u0580\u0565\u0561\u056f\u0561\u0576 \u057e\u0578\u0576" },
            { "NGN", "NGN" },
            { "bob", "\u0562\u0578\u056c\u056b\u057e\u056b\u0561\u056f\u0561\u0576 \u0562\u0578\u056c\u056b\u057e\u056b\u0561\u0576\u0578" },
            { "mdl", "\u0574\u0578\u056c\u0564\u0578\u057e\u0561\u056f\u0561\u0576 \u056c\u0565\u0575" },
            { "CRC", "CRC" },
            { "PKR", "PKR" },
            { "amd", "\u0570\u0561\u0575\u056f\u0561\u056f\u0561\u0576 \u0564\u0580\u0561\u0574" },
            { "ANG", "ANG" },
            { "try", "\u0569\u0578\u0582\u0580\u0584\u0561\u056f\u0561\u0576 \u056c\u056b\u0580\u0561" },
            { "lbp", "\u056c\u056b\u0562\u0561\u0576\u0561\u0576\u0575\u0561\u0576 \u0586\u0578\u0582\u0576\u057f" },
            { "jod", "\u0570\u0578\u0580\u0564\u0561\u0576\u0561\u0576\u0575\u0561\u0576 \u0564\u056b\u0576\u0561\u0580" },
            { "hkd", "\u0540\u0578\u0576\u056f\u0578\u0576\u0563\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "eur", "\u0565\u057e\u0580\u0578" },
            { "SRD", "SRD" },
            { "LTL", "LTL" },
            { "SAR", "SAR" },
            { "TTD", "TTD" },
            { "cad", "\u056f\u0561\u0576\u0561\u0564\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "MVR", "MVR" },
            { "mur", "\u0574\u0561\u057e\u0580\u056b\u056f\u0575\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "gip", "\u054b\u056b\u0562\u0580\u0561\u056c\u0569\u0561\u0580\u056b \u0586\u0578\u0582\u0576\u057f" },
            { "ron", "\u057c\u0578\u0582\u0574\u056b\u0576\u0561\u056f\u0561\u0576 \u056c\u0565\u0575" },
            { "AOA", "AOA" },
            { "PLN", "PLN" },
            { "SBD", "SBD" },
            { "ngn", "\u0576\u056b\u0563\u0565\u0580\u056b\u0561\u056f\u0561\u0576 \u0576\u0561\u0575\u0580\u0561" },
            { "crc", "\u053f\u0578\u057d\u057f\u0561 \u054c\u056b\u056f\u0561\u0575\u056b \u056f\u0578\u056c\u0578\u0576" },
            { "pkr", "\u057a\u0561\u056f\u056b\u057d\u057f\u0561\u0576\u0575\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "ang", "\u0576\u056b\u0564\u0565\u057c\u056c\u0561\u0576\u0564\u0561\u056f\u0561\u0576 \u0561\u0576\u057f\u056b\u056c\u0575\u0561\u0576 \u0563\u0578\u0582\u056c\u0564\u0565\u0576" },
            { "MWK", "MWK" },
            { "srd", "\u057d\u0578\u0582\u0580\u056b\u0576\u0561\u0574\u0561\u056f\u0561\u0576 \u0564\u0578\u056c\u0561\u0580" },
            { "ltl", "\u053c\u056b\u057f\u057e\u0561\u056f\u0561\u0576 \u056c\u056b\u057f" },
            { "sar", "\u054d\u0561\u0578\u0582\u0564\u0575\u0561\u0576 \u0531\u0580\u0561\u0562\u056b\u0561\u0575\u056b \u057c\u056b\u0561\u056c" },
            { "ttd", "\u054f\u0580\u056b\u0576\u056b\u0564\u0561\u0564 \u0587 \u054f\u0578\u0562\u0561\u0563\u0578\u0575\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "MGA", "MGA" },
            { "mvr", "\u0574\u0561\u056c\u0564\u056b\u057e\u0575\u0561\u0576 \u057c\u0578\u0582\u0586\u056b\u0575\u0561" },
            { "inr", "\u0570\u0576\u0564\u056f\u0561\u056f\u0561\u0576 \u057c\u0578\u0582\u0583\u056b" },
            { "BAM", "BAM" },
            { "EGP", "EGP" },
            { "SSP", "SSP" },
            { "krw", "\u0570\u0561\u0580\u0561\u057e\u056f\u0578\u0580\u0565\u0561\u056f\u0561\u0576 \u057e\u0578\u0576" },
            { "aoa", "\u0561\u0576\u0563\u0578\u056c\u0561\u056f\u0561\u0576 \u056f\u057e\u0561\u0576\u0566\u0561" },
            { "jpy", "\u0573\u0561\u057a\u0578\u0576\u0561\u056f\u0561\u0576 \u056b\u0565\u0576" },
            { "pln", "\u056c\u0565\u0570\u0561\u056f\u0561\u0576 \u0566\u056c\u0578\u057f\u056b" },
            { "sbd", "\u054d\u0578\u0572\u0578\u0574\u0578\u0576\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580\u056b \u0564\u0578\u056c\u0561\u0580" },
            { "NIO", "NIO" },
        };
        return data;
    }
}
